


class AppConfig {
	
	
	isAdmin() {
		return toolboxConfig.admin ? true : false;
	}
	
	getUserId() {
		return toolboxConfig.userId;
	}
	
	getUsername() {
		return toolboxConfig.username;
	}
	
	
	hasPermission( permissionName ) {
		// admin has access to everything
		if ( this.isAdmin() )
			return true;
		
		
		if ( !toolboxConfig.user || !toolboxConfig.user.permissions ) {
			return false;
		}
		
		for(let i=0; i < toolboxConfig.user.permissions.length; i++) {
			let p = toolboxConfig.user.permissions[i];
			
			if (p.refObject == permissionName || p.refObject == 'up.'+permissionName) {
				if (p.accessMethod == 'full' || p.accessMethod == 'restricted') {
					return true;
				}
			}
		}
 		
		return false;
	}
	
	
}


export const appConfig = new AppConfig();



